/*
 * Decompiled with CFR 0.152.
 */
package com.skloch.game.gamelogic;

import com.badlogic.gdx.maps.MapProperties;
import com.badlogic.gdx.math.Rectangle;

public class GameObject
extends Rectangle {
    public MapProperties properties;
    public float centreX;
    public float centreY;

    public GameObject(float x, float y, float width, float height) {
        super(x, y, width, height);
        this.properties = new MapProperties();
        this.centreX = x + width / 2.0f;
        this.centreY = y + height / 2.0f;
    }

    public GameObject(MapProperties objectProperties, float scale) {
        super(((Float)objectProperties.get("x")).floatValue() * scale, ((Float)objectProperties.get("y")).floatValue() * scale, ((Float)objectProperties.get("width")).floatValue() * scale, ((Float)objectProperties.get("height")).floatValue() * scale);
        this.properties = objectProperties;
        this.centreX = this.x + this.width / 2.0f;
        this.centreY = this.y + this.height / 2.0f;
    }

    public void put(String key, Object value) {
        this.properties.put(key, value);
    }

    public Object get(String key) {
        return this.properties.get(key);
    }

    public boolean containsKey(String key) {
        return this.properties.containsKey(key);
    }

    public void setCentreY(float y) {
        this.centreY = y;
    }

    public void setCentreX(float x) {
        this.centreX = x;
    }
}

